/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.modules.api;

import com.floragunn.searchguard.modules.api.GetComponentStateAction;
import com.floragunn.searchsupport.action.StandardResponse;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;

public class ComponentStateRestAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(ComponentStateRestAction.class);

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/component/{id}/_health"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.method() == RestRequest.Method.GET) {
            return this.handleGet(request.param("id"), request.paramAsBoolean("verbose", false), client);
        }
        return channel -> new StandardResponse(405, "Method not allowed: " + request.method());
    }

    private BaseRestHandler.RestChannelConsumer handleGet(String id, boolean verbose, NodeClient client) {
        return channel -> {
            try {
                client.execute((ActionType)GetComponentStateAction.INSTANCE, (ActionRequest)new GetComponentStateAction.Request(id, verbose), (ActionListener)new RestStatusToXContentListener(channel));
            }
            catch (Exception e) {
                log.error((Object)e);
                channel.sendResponse(new StandardResponse(e).toRestResponse());
            }
        };
    }

    public String getName() {
        return "Search Guard Component Health";
    }
}

